function [IRF_a, IRF_u] = IRF_series(parameters)
% This function computes the Impulse Response Function given model
% parameters.
% Input:
% parameters ~ a 17x1 vector with the model parameters

global oo_

beta    = parameters(1); 
th_n_ss = parameters(2);     
th_o_ss = parameters(3);     
MS_o    = parameters(4);
lambda  = parameters(5);
eta     = parameters(6);        
R_O     = parameters(7);
gamma   = parameters(8);
L       = parameters(9);
alpha   = parameters(10);
delta   = parameters(11);
nu      = parameters(12);

epsilon = parameters(13);
rho_a1  = parameters(14);
rho_a2  = parameters(15);
u_var   = parameters(16);    
a_var   = parameters(17); 

est_par_names = {'beta', 'epsilon', 'alpha', 'eta', 'lambda', 'nu', 'delta', 'gamma'}; %, 'psi'
for i = 1:length(est_par_names)
    eval(['estim_param.' est_par_names{i} ' = ' est_par_names{i} ';']);
end

calib_targets.theta_n = th_n_ss;
calib_targets.theta_o = th_o_ss;
calib_targets.MS_o    = MS_o;
calib_targets.R_o     = R_O;
calib_targets.L       = L;

[struct_param, endo_ss, ~] = calibrate_ss(estim_param, calib_targets);

shock_param.rho_a1  = rho_a1;
shock_param.rho_a2  = rho_a2;
shock_param.u_var   = u_var;
shock_param.a_var   = a_var;


save calibration_parameters struct_param shock_param endo_ss

evalc('dynare World_Economy_Cartel_IRF.mod');   % Run model

var_names   = {'a' 'u' 'p' 'prod_n' 'prod_o' 'theta_n' 'theta_o' 'F_n' 'F_o' 'I_n' 'I_o' 'Y' 'L' 'K' 'C' 'r' 'o' 'X_n', 'X_o'};
shock_names = {'a' 'u'};

for i = 1:2
    for j = 1:length(var_names)
        eval(['IRF_' shock_names{i} '.' var_names{j} ' = oo_.irfs.' var_names{j} '_eps_' shock_names{i} ';']);
    end
end
